// UserEnvMessage.cpp starts

#include <string.h>
#include "Debug.h"
#include "UserEnvMessage.h"
#include <Message.h>
#include <Messenger.h>

/* Class for sending messages from User Interface and Experimenter to Environment
 */

void UserEnvMessage::GetRatLocation(int &armNumber)
{
	BMessage msg(USERMSG_GET_RAT_LOCATION);
	BMessage reply;
	status_t status;
	int16 spoke;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::GetRatLocation: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::GetRatLocation: Error sending message");
	}
	
	if ((status = reply.FindInt16("arm_number", &spoke)) != B_OK) {
		Debug('e', "UserEnvMessage::GetRatLocation: Error decoding reply: ", strerror(status));
	}
	armNumber = (int) spoke;
	
	delete messenger;
}

bool UserEnvMessage::IsArbitraryDoorOpen(int armNumber)
{
	BMessage msg(USERMSG_IS_ARBITRARY_DOOR_OPEN);
	BMessage reply;
	status_t status;
	bool result;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::IsArbitraryDoorOpen: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::IsArbitraryDoorOpen: Error sending message");
	}
	
	if ((status = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "UserEnvMessage::IsArbitraryDoorOpen: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	return result;
}

void UserEnvMessage::PlaceFood(int armNumber)
{
	BMessage msg(USERMSG_PLACE_FOOD);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::PlaceFood: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::PlaceFood: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "RatEnvMessage::PlaceFood: Message was NOT a reply!!!!");
	}
		
	delete messenger;
}

void UserEnvMessage::RemoveFood(int armNumber)
{
	BMessage msg(USERMSG_REMOVE_FOOD);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::RemoveFood: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::RemoveFood: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "UserEnvMessage::RemoveFood: Message was NOT a reply!!!!");
	}
		
	delete messenger;
}

void UserEnvMessage::OpenDoor(int armNumber)
{
	BMessage msg(USERMSG_OPEN_DOOR);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::OpenDoor: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::OpenDoor: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "UserEnvMessage::OpenDoor: Message was NOT a reply!!!!");
	}
		
	delete messenger;
}

void UserEnvMessage::CloseDoor(int armNumber)
{
	BMessage msg(USERMSG_CLOSE_DOOR);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::CloseDoor: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::CloseDoor: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "UserEnvMessage::CloseDoor: Message was NOT a reply!!!!");
	}
		
	delete messenger;
}

void UserEnvMessage::WarpTo(int armNumber)
{
	BMessage msg(USERMSG_WARP_TO);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::WarpTo: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::WarpTo: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "UserEnvMessage::WarpTo: Message was NOT a reply!!!!");
	}
		
	delete messenger;
}

bool UserEnvMessage::IsFoodAtLocation(int armNumber)
{
	BMessage msg(USERMSG_IS_FOOD_AT_LOCATION);
	BMessage reply;
	status_t status;
	bool result;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::IsFoodAtLocation: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("arm_number", (int16) armNumber);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::IsFoodAtLocation: Error sending message");
	}
	
	if ((status = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "UserEnvMessage::IsFoodAtLocation: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	return result;
}

void UserEnvMessage::SetNumberOfMazeArms(int numberArms)
{
	BMessage msg(USERMSG_SET_NUMBER_OF_ARMS);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::SetNumberOfMazeArms: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("number_of_arms", (int16) numberArms);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::SetNumberOfMazeArms: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "UserEnvMessage::SetNumberOfMazeArms: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

int UserEnvMessage::GetNumberOfMazeArms()
{
	BMessage msg(USERMSG_GET_NUMBER_OF_ARMS);
	BMessage reply;
	status_t status;
	int16 result;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::GetNumberOfMazeArms: Error creating messenger: ", strerror(status));
	}

	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::GetNumberOfMazeArms: Error sending message");
	}
	
	if ((status = reply.FindInt16("number_of_arms", &result)) != B_OK) {
		Debug('e', "UserEnvMessage::GetNumberOfMazeArms: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	return (int) result;
}

int UserEnvMessage::GetCurrHeading()
{
	BMessage msg(USERMSG_GET_CURR_HEADING);
	BMessage reply;
	status_t status;
	int16 result;
	
	//Debug('t', "UserEnvMessage::GetCurrHeading: Bug Test1");
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	//Debug('t', "UserEnvMessage::GetCurrHeading: Bug Test1.1.1");
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::GetCurrHeading: Error creating messenger: ", strerror(status));
	}
	//Debug('t', "UserEnvMessage::GetCurrHeading: Bug Test1.1");

	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::GetCurrHeading: Error sending message");
	}
	//Debug('t', "UserEnvMessage::GetCurrHeading: Bug Test1.2");
	
	if ((status = reply.FindInt16("heading", &result)) != B_OK) {
		Debug('e', "UserEnvMessage::GetCurrHeading: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	//Debug('t', "UserEnvMessage::GetCurrHeading: Bug Test2");
	
	return (int) result;
}

bool UserEnvMessage::GetDisplayChange()
{
	BMessage msg(USERMSG_GET_DISPLAY_CHANGE);
	BMessage reply;
	status_t status;
	bool result;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::GetDisplayChange: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::GetDisplayChange: Error sending message");
	}
	
	if ((status = reply.FindBool("flag", &result)) != B_OK) {
		Debug('e', "UserEnvMessage::GetDisplayChange: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	return result;
}

void UserEnvMessage::ResetDisplayChange()
{
	BMessage msg(USERMSG_RESET_DISPLAY_CHANGE);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) env, &status);
	if (status != B_OK) {
		Debug('e', "UserEnvMessage::ResetDisplayChange: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "UserEnvMessage::ResetDisplayChange: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "UserEnvMessage::ResetDisplayChange: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

// UserEnvMessage.cpp ends